# XORCE

XOR Algebra Compiler with holonomy verification and algebraic computation.

## Build

```
make
```

## Usage

```
./xorce examples/flat.xor          # Compile source file
./xorce -r                          # Start interactive REPL
./xorce --verify logic.xorc         # Verify chip seal
./xorce -i logic.xorc               # Inspect chip file
```

## Source Language

```
kernel pauli2 : pauli(2);
verify pauli2 : associative;
export pauli2 as "pauli2.xorc";
```

### Kernel Families

- `flat N` - Trivial kernel
- `pauli(n)` - n-qubit Pauli group
- `clifford(p, q)` - Clifford algebra Cl(p,q)
- `cayley(level)` - Cayley-Dickson (1=complex, 2=quaternions, 3=octonions)

### Properties

- `associative` - All 3-bubbles equal +1
- `commutative` - All 2-bubbles equal +1
- `center = N` - Center dimension
- `radical = N` - Radical dimension

## Interactive REPL

Start with `./xorce -r` or `./xorce --repl`:

```
xorce> load pauli2.xorc
Loaded: pauli2.xorc, dim=4, 16 elements

xorce> mul 1 2
delta_1 * delta_2 = +delta_3

xorce> assoc 1 2 3
(delta_1 * delta_2) * delta_3 = +delta_0
delta_1 * (delta_2 * delta_3) = +delta_0
  [associative]

xorce> comm 1 2
delta_1 * delta_2 = +delta_3
delta_2 * delta_1 = +delta_3
  [commute]

xorce> table
    |  0  1  2  3
----+------------
  0 |  +  +  +  +
  1 |  +  +  -  -
  ...

xorce> center
Center (1 elements): 0

xorce> quit
```

### REPL Commands

| Command              | Description                           |
|---------------------|---------------------------------------|
| `load <file.xorc>`  | Load a chip file                      |
| `mul <u> <v>`       | Compute delta_u * delta_v             |
| `assoc <u> <v> <w>` | Test associativity at (u,v,w)         |
| `comm <u> <v>`      | Test commutativity at (u,v)           |
| `table`             | Print omega table (dim <= 4)          |
| `info`              | Show loaded chip info                 |
| `center`            | List center elements                  |
| `radical`           | List radical elements                 |
| `help`              | Show command help                     |
| `quit` / `exit`     | Exit REPL                             |

## Algebra Operations

The compiler implements actual algebraic computation:

- **Element multiplication**: `delta_u * delta_v = omega(u,v) * delta_{u XOR v}`
- **Associator test**: `(a*b)*c` vs `a*(b*c)`, returns +1 if associative, -1 otherwise
- **Commutator test**: `a*b` vs `b*a`, returns +1 if commute, -1 if anticommute
- **Center**: Elements that commute with all others
- **Radical**: Elements that are both central and associative

## Output

.xorc chips contain a 64-byte header, phase kernel table, and SHA-256 seal.

## License

CC BY 4.0 - Airo Nahiru

https://aironahiru.com/xorce/
